---
description: "Learn more about: Enumerations"
title: "Accessing data enumerations"
---
# Enumerations

The Power Query M formula language includes these enumerations.

## List of enumerations

|Name|Description|
|------------|---------------|
|[AccessControlKind.Type](accesscontrolkind-type.md)|Specifies the kind of access control.|
|[BinaryEncoding.Type](binaryencoding-type.md)|Specifies the type of binary encoding.|
|[BinaryOccurrence.Type](binaryoccurrence-type.md)|Specifies how many times the item is expected to appear in the group.|
|[BufferMode.Type](buffermode-type.md)|Describes the type of buffering to be performed.|
|[ByteOrder.Type](byteorder-type.md)|Specifies the byte order.|
|[Compression.Type](compression-type.md)|Specifies the type of compression.|
|[CsvStyle.Type](csvstyle-type.md)|Specifies the significance of quotes in a CSV document.|
|[Day.Type](day-type.md)|Represents the day of the week.|
|[ExtraValues.Type](extravalues-type.md) | Specifies the expected action for extra values in a row that contains columns less than expected.|
|[GroupKind.Type](groupkind-type.md) | Specifies the kind of grouping.|
|[JoinAlgorithm.Type](joinalgorithm-type.md) |Specifies the join algorithm to be used in the join operation.|
|[JoinKind.Type](joinkind-type.md) |Specifies the kind of join operation.|
|[JoinSide.Type](joinside-type.md) | Specifies the left or right table of a join.|
|[LimitClauseKind.Type](limitclausekind-type.md)|Indicates the features that the specific SQL dialect supports.|
|[MissingField.Type](missingfield-type.md)|Specifies the expected action for missing values in a row that contains columns less than expected.|
|[Occurrence.Type](occurrence-type.md)|Specifies the occurrence of an element in a sequence.|
|[ODataOmitValues.Type](odataomitvalues-type.md)|Specifies the kinds of values an OData service can omit.|
|[Order.Type](order-type.md) | Specifies the direction of sorting.|
|[PercentileMode.Type](percentilemode-type.md) | Specifies the percentile mode type.|
|[Precision.Type](precision-type.md)|Specifies the precision of comparison.|
|[QuoteStyle.Type](quotestyle-type.md) | Specifies the quote style.|
|[RankKind.Type](rankkind-type.md)|Specifies the precise ranking method.|
|[RelativePosition.Type](relativeposition-type.md) | Indicates whether indexing should be done from the start or end of the input.|
|[RoundingMode.Type](roundingmode-type.md)|Specifies rounding direction when there is a tie between the possible numbers to round to.|
|[SapBusinessWarehouseExecutionMode.Type](sapbusinesswarehouseexecutionmode-type.md)|Specifies valid options for SAP Business Warehouse execution mode option.|
|[SapHanaDistribution.Type](saphanadistribution-type.md)|Specifies valid options for SAP HANA distribution option.|
|[SapHanaRangeOperator.Type](saphanarangeoperator-type.md)|Specifies a range operator for SAP HANA range input parameters.|
|[TextEncoding.Type](textencoding-type.md) | Specifies the text encoding type.|
|[TraceLevel.Type](tracelevel-type.md)|Specifies the trace level.|
|[WebMethod.Type](webmethod-type.md) |Specifies an HTTP method.|
